-- Lister les tables internes en charge du suivi de modifications
USE AdventureWorks2012
GO

SELECT	*
FROM	sys.all_objects
WHERE	type_desc = 'INTERNAL_TABLE'
AND	name LIKE 'change?_tracking%' ESCAPE '?'

SELECT	*
FROM	sys.internal_tables
WHERE	internal_type_desc = 'CHANGE_TRACKING'

SELECT		S.name + '.' + T.name AS table_name
		, TT.is_track_columns_updated_on
		, TT.min_valid_version
		, TT.begin_version
		, TT.cleanup_version
FROM		sys.change_tracking_tables AS TT
INNER JOIN	sys.tables AS T
			ON T.object_id = TT.object_id
INNER JOIN	sys.schemas AS S
			ON S.schema_id = T.schema_id